local Button = require "widgets/button"
local AnimButton = require "widgets/animbutton"
local ImageButton = require "widgets/imagebutton"
local TextButton = require "widgets/textbutton"
local Text = require "widgets/text"
local Image = require "widgets/image"
local Widget = require "widgets/widget"
local Menu = require "widgets/menu"
local TileBG = require "widgets/tilebg"
local pickyEater_InvSlot = require "widgets/pickyEater_invSlot"
local pickyEater_ItemTile = require "widgets/pickyEater_itemTile"
local pickyEater = require "components/pickyEater"
local screenwidth, screenheight = TheSim:GetScreenSize()

local Screen = require "widgets/screen"


local foodMenu = Class(Widget, function(self, owner)
	self.owner = owner
	Widget._ctor(self, "foodMenu")

	self.options = GetPlayer().components.pickyEater.options
	self.root = self:AddChild(Widget("ROOT"))
	self.root:SetVAnchor(ANCHOR_MIDDLE)
	self.root:SetHAnchor(ANCHOR_MIDDLE)
	self.root:SetScaleMode(SCALEMODE_PROPORTIONAL)
	self.root:SetPosition(0,0,0)

	self.root_top = self:AddChild(Widget("ROOT"))
	self.root_top:SetVAnchor(ANCHOR_TOP)
	self.root_top:SetHAnchor(ANCHOR_MIDDLE)
	self.root_top:SetScaleMode(SCALEMODE_PROPORTIONAL)
	self.root_top:SetPosition(0,-80,0)
	
	self.root_bottom = self:AddChild(Widget("ROOT"))
	self.root_bottom:SetVAnchor(ANCHOR_BOTTOM)
	self.root_bottom:SetHAnchor(ANCHOR_MIDDLE)
	self.root_bottom:SetScaleMode(SCALEMODE_PROPORTIONAL)
	self.root_bottom:SetPosition(0,-80,0)
	--self.root_bottom:SetMaxPropUpscale(MAX_HUD_SCALE)
	
	self.boardShow = true
	self.menuShow = false
	self.controllerFocus = false

	self.inst:DoTaskInTime(1, function() 
		if GetPlayer().components.pickyEater.table.tarFood[1] == nil then
			GetPlayer().components.pickyEater:reset()
			self.inst:DoTaskInTime(0.2, function() self:optionsDisplay() end)	
			self.inst:DoTaskInTime(0.3, function() self:boardDisplay() end)	
			self.inst:DoTaskInTime(0.5, function() self:Rebuild() end)
			self.inst:DoTaskInTime(0.55, function() self:StartUpdating() end)
		else 
			self.inst:DoTaskInTime(0.1, function() self:optionsDisplay() end)
			self.inst:DoTaskInTime(0.2, function() self:boardDisplay() end)			
			self.inst:DoTaskInTime(0.5, function() self:Rebuild() end)
			self.inst:DoTaskInTime(0.55, function() self:StartUpdating() end)		
		end
	end)
end)

function foodMenu:OnUpdate(dt)
	if GetPlayer().components.pickyEater.update == true then
		GetPlayer().components.pickyEater.update = false
		self:Rebuild()
	end
end

function foodMenu:OnGainFocus()
	if self.boardShow == true then
		if not self.optionsMenu:OnGainFocus() then
			self.boardArrowR:Show()
			self.crockHelpButton:Show()
			self.optionsMenuButton:Show()
		end
	end
end

function foodMenu:OnLoseFocus()
	if self.boardShow == true then
		self.boardArrowR:Hide()
		self.crockHelpButton:Hide()
		self.optionsMenuButton:Hide()
	end
	if self.boardShow ~= true and self.menuShow == false then
		self.optionsMenuButton:Hide()
		self.crockHelpButton:Hide()
	end
end

function foodMenu:Rebuild()
	if self.board.slots ~= nil then
		self.board.slots:Kill()
	end

	self.board.slots = self.board:AddChild(Widget("SLOTS"))

	if self.board.inv then
		for k,v in pairs(self.board.inv) do
			v:Kill()
		end
	end

	self.board.inv = {}

	local HUD_ATLAS = "images/hud.xml"
	local maxSlots = GetPlayer().components.pickyEater.table.limit
	local W = 66
	local H = 66
	local maxwidth = 1700
	local positions = 0
	local NUM_COLUMS = 10

	for k = 1, maxSlots do
		local inv_slot = "inv_slot.tex"

		if GetPlayer().components.pickyEater.table.checker[k] == true then
			inv_slot = "resource_needed.tex"
		end

		local height = math.floor(positions / NUM_COLUMS) * H
		local slot = pickyEater_InvSlot(k, HUD_ATLAS, inv_slot, self, GetPlayer().components.pickyEater.table.tarFood)
	 	self.board.inv[k] = self.board.slots:AddChild(slot)
		self.board.inv[k]:SetTile(pickyEater_ItemTile(GetPlayer().components.pickyEater.table.tarFood[k]))

		local remainder = positions % NUM_COLUMS
		local row = math.floor(positions / NUM_COLUMS) * H

		local x = W * remainder
		slot:SetPosition(x,-row,0)
		positions = positions + 1
	end
end

function foodMenu:optionsDisplay()	
	self.optionsMenu = self.root:AddChild( Image("images/pickyeater_ui.xml", "in-window_button_tile_idle.tex") )
	self.optionsMenu:SetScale(.9,.9,.9)
	if widg_loc == 1 then
		self.optionsMenu:SetPosition(0, -85, 0)			
	else
		self.optionsMenu:SetPosition(0, 120, 0)		
	end
	self.optionsMenu:SetSize(700, 480)
	self.optionsMenu:SetTint(0.9,.9,.9,0.8)
	self.optionsMenu:Hide()

	self.whiteline1 = self.optionsMenu:AddChild( Image("images/pickyeater_ui.xml", "line_horizontal_5.tex") )
	self.whiteline1:SetScale(1,1,1)
	self.whiteline1:SetPosition(15, 155, 0)
	self.whiteline1:SetSize(440, 2.5)
	self.whiteline1:SetTint(1,1,1,1)

	self.whiteline2 = self.optionsMenu:AddChild( Image("images/pickyeater_ui.xml", "line_horizontal_5.tex") )
	self.whiteline2:SetScale(1,1,1)
	self.whiteline2:SetPosition(-3, -151, 0)
	self.whiteline2:SetSize(640, 3.2)
	self.whiteline2:SetTint(1,1,1,0.9)

	self.bingoControlPan = self.optionsMenu:AddChild(TextButton())
	self.bingoControlPan:SetFont(TITLEFONT)
	self.bingoControlPan:SetText("Picky Eater Control Menu")
	self.bingoControlPan:SetPosition(5, 184, 0)
	self.bingoControlPan:SetTextSize(58)
	self.bingoControlPan:SetColour(0.25,0.25,0.25,1)
	self.bingoControlPan:SetClickable(false)
	
	self.resetBoardButton = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "button_large.tex", "button_large_over.tex", "button_large_disabled.tex", "button_large_onclick.tex"))		
	self.resetBoardButton:SetScale(0.9,.6,.75)
	self.resetBoardButton:SetPosition(0,-184,0)
	self.resetBoardButton:SetFont(BUTTONFONT)
	self.resetBoardButton:SetText("Reset")
	self.resetBoardButton:SetTextSize(45)
	self.resetBoardButton:SetOnClick( function()
		GetPlayer().components.pickyEater:reset()
		self.resetBoardButton:SetClickable(false)
		self.inst:DoTaskInTime(1, function() self:boardDisplay() end)
		self.inst:DoTaskInTime(1.1, function() self:Rebuild() end)
		self.inst:DoTaskInTime(2.1, function() self.resetBoardButton:SetClickable(true) end)
	end)

	self:checkBoxes()
	self:text()
end

function foodMenu:boardDisplay()

	if self.boardParent and self.boardParent ~= nil then
		if self.boardShow == false then
			self.boardShow = true
			self.board:Show()
			self.boardBG:Show()
			self.boardTitle:Show()
			self.boardArrow2:SetTooltip('hide board')
			self.boardArrowR:SetTooltip('hide board')
			if widg_loc == 2 then
				self.boardArrow2:Hide()
				self.boardArrowR:Show()
			end
		end
		self.boardParent:Kill()
		self:Rebuild()
	end

	if widg_loc == 1 then
		self.boardParent = self.root_top:AddChild( Image("images/ui.xml", "blank.tex") )
	end
	if widg_loc == 2 then
		self.boardParent = self.root_bottom:AddChild( Image("images/ui.xml", "blank.tex") )
	end
	self.boardParent:SetSize(1, 1,0)
	self.boardParent:SetScale(1,1,1)
	if widg_loc == 1 then
		self.boardParent:SetPosition(0, -48, 0)				
	else
		if GetPlayer().components.pickyEater.table.limit <= 10 then
			self.boardParent:SetPosition(0, 105, 0)			
		elseif GetPlayer().components.pickyEater.table.limit <= 20 then
			self.boardParent:SetPosition(0, 145, 0)			
		elseif GetPlayer().components.pickyEater.table.limit <= 30 then
			self.boardParent:SetPosition(0, 185, 0)			
		else
			self.boardParent:SetPosition(0, 220, 0)			
		end	
	end
	self.boardBG = self.boardParent:AddChild( Image("images/ui.xml", "black.tex") )
	self.boardBG:SetScale(1,1,1)
	self.boardBG:SetTint(1,1,1,0.6)
	
	if GetPlayer().components.pickyEater.table.limit <= 10 then
		self.boardBG:SetSize(390, 80)
		self.boardBG:SetPosition(-1,78,0) 
	elseif GetPlayer().components.pickyEater.table.limit <= 20 then
		self.boardBG:SetSize(390, 120)
		self.boardBG:SetPosition(-1,60,0) 
	elseif GetPlayer().components.pickyEater.table.limit <= 30 then
		self.boardBG:SetSize(390, 155)
		self.boardBG:SetPosition(-1,40,0)
	else
		self.boardBG:SetSize(390, 193)
		self.boardBG:SetPosition(-1,21,0)
	end

	self.board = self.boardParent:AddChild( Image("images/ui.xml", "blank.tex") )
	self.board:SetScale(.57,.57,.57)
	self.board:SetPosition(-170,62,0)
---[[
	self.boardArrowR = self.boardParent:AddChild(ImageButton("images/pickyeater_ui.xml", "red_star.tex", "red_star.tex", "red_star.tex"))
	self.boardArrowR:SetScale(1.5,1.5,1.5)
	self.boardArrowR:SetPosition(150,100,0)	

	self.boardArrowR:SetTooltip("hide board (" .. Toggle_Key .. ")")
	--self.boardArrowR:SetTooltipPos(0, 8, 0)
	self.boardArrowR:Hide()
	self.boardArrowR:SetOnClick( function() 
		if self.boardShow == true then
			self.boardShow = false
			self.board:Hide()
			self.boardBG:Hide()
			self.boardTitle:Hide()
			self.boardArrowR:SetTooltip('show board')
			self.boardArrow2:SetTooltip('show board')
			if widg_loc == 2 then
				self.boardArrowR:Hide()
				self.boardArrow2:Show()
			end
		else
			self.boardShow = true
			self.board:Show()
			self.boardBG:Show()
			self.boardTitle:Show()
			self.boardArrowR:SetTooltip("hide board (" .. Toggle_Key .. ")")
		end
	end)

	self.boardArrow2 = self.boardParent:AddChild(ImageButton("images/pickyeater_ui.xml", "red_star.tex", "red_star.tex", "red_star.tex"))
	self.boardArrow2:SetScale(1.5,1.5,1.5)	
	if GetPlayer().components.pickyEater.table.limit <= 10 then
		self.boardArrow2:SetPosition(510,10,0)			
	elseif GetPlayer().components.pickyEater.table.limit <= 20 then
		self.boardArrow2:SetPosition(510,-25,0)		
	elseif GetPlayer().components.pickyEater.table.limit <= 30 then
		self.boardArrow2:SetPosition(510,-58,0)		
	elseif GetPlayer().components.pickyEater.table.limit <= 40 then
		self.boardArrow2:SetPosition(510,-90,0)		
	else
		self.boardArrow2:SetPosition(510,-25,0)		
	end
	self.boardArrow2:SetTooltip("hide board (" .. Toggle_Key .. ")")
	--self.boardArrow2:SetTooltipPos(0, 8, 0)
	self.boardArrow2:Hide()
	self.boardArrow2:SetOnClick( function() 
		if self.boardShow == true then
			self.boardShow = false
			self.board:Hide()
			self.boardBG:Hide()
			self.boardTitle:Hide()
			self.boardArrow2:SetTooltip('show board')
		else
			self.boardShow = true
			self.board:Show()
			self.boardBG:Show()
			self.boardTitle:Show()
			self.boardArrow2:SetTooltip("hide board (" .. Toggle_Key .. ")")
			self.boardArrowR:SetTooltip("hide board (" .. Toggle_Key .. ")")
			if widg_loc == 2 then
				self.boardArrow2:Hide()
				self.boardArrowR:Show()
			end
		end
	end)
	
	self.optionsMenuButton = self.boardParent:AddChild(ImageButton("images/pickyeater_ui.xml", "mods.tex", "mods.tex", "mods.tex"))
	self.optionsMenuButton:SetScale(.13,.13,.13)
	self.optionsMenuButton:SetPosition(-170,96,0)	
	self.optionsMenuButton:SetTooltip('show settings menu')
	--self.optionsMenuButton:SetTooltipPos(0, 8, 0)
	self.optionsMenuButton:Hide()
	self.optionsMenuButton:SetOnClick( function() 
		if self.menuShow == false then
			self.menuShow = true
			self.optionsMenu:Show()
			self.optionsMenuButton:SetTooltip('hide settings menu')
		else
			self.menuShow = false
			self.optionsMenu:Hide()
			self.optionsMenuButton:SetTooltip('show settings menu')
		end
	end)

	self.crockHelpButton = self.boardParent:AddChild(ImageButton("images/pickyeater_ui.xml", "exclamationmark.tex", "exclamationmark.tex", "exclamationmark.tex"))
	self.crockHelpButton:SetScale(1,1,1)
	self.crockHelpButton:SetPosition(-132,98,0)	
	self.crockHelpButton:SetTooltip('show crockpot help')
	--self.optionsMenuButton:SetTooltipPos(0, 8, 0)
	self.crockHelpButton:Hide()
	self.crockHelpButton:SetOnClick( function() 
		if self.menuShow == false then
			self.menuShow = true
			self.hintBG:Show()
			self.crockHelpButton:SetTooltip('hide crockpot help')
		else
			self.menuShow = false
			self.hintBG:Hide()
			self.crockHelpButton:SetTooltip('show crockpot help')
		end
	end)
--]]
	self.boardTitle = self.boardParent:AddChild(TextButton())
	self.boardTitle:SetFont(TITLEFONT)
	self.boardTitle:SetText("P  I  C  K  Y        E  A  T  E  R")
	self.boardTitle:SetTextSize(30)
	self.boardTitle:SetColour(0.9,0.8,0.6,1)
	self.boardTitle:SetPosition(0, 93, 0)
	self.boardTitle:SetClickable(false) 
	
	self.hintBG = self.boardParent:AddChild( Image("images/ui.xml", "black.tex") )
	self.hintBG:SetScale(1,1,1)
	self.hintBG:SetTint(1,1,1,0.6)
	self.hintBG:SetSize(160, 180)
	if widg_loc == 2 and GetPlayer().components.pickyEater.table.limit <= 20 then
		self.hintBG:SetPosition(-300,100,0)	
	else
		self.hintBG:SetPosition(-300,28,0) 
	end
	
	self.hintText = self.hintBG:AddChild(Text(TALKINGFONT, 24))
	self.hintText:SetPosition(0, 0, 0)
	self.hintText:EnableWordWrap(true)
	self.hintText:SetRegionSize(150, 150)
	self.hintText:SetColour(1,1,1,1)	
	
	self.hintBG:Hide()
end

function foodMenu:text()
	self.IncludeDLCText = self.optionsMenu:AddChild(TextButton())
	self.IncludeDLCText:SetFont(UIFONT)
	self.IncludeDLCText:SetText("DLCs:")
	self.IncludeDLCText:SetPosition(30, 35, 0)
	self.IncludeDLCText:SetTextSize(33)
	self.IncludeDLCText:SetColour(0.25,0.25,0.25,1)
	self.IncludeDLCText:SetClickable(false)

	self.SWText = self.optionsMenu:AddChild(TextButton())
	self.SWText:SetFont(DEFAULTFONT)
	self.SWText:SetText("Shipwrecked")
	self.SWText:SetPosition(199, 34, 0)
	self.SWText:SetTextSize(24)
	self.SWText:SetColour(0,0,0,1)
	self.SWText:SetClickable(false)
	
	self.RoGText = self.optionsMenu:AddChild(TextButton())
	self.RoGText:SetFont(DEFAULTFONT)
	self.RoGText:SetText("Reign of Giants")
	self.RoGText:SetPosition(211, 2, 0)
	self.RoGText:SetTextSize(24)
	self.RoGText:SetColour(0,0,0,1)
	self.RoGText:SetClickable(false)
	
	self.VanillaText = self.optionsMenu:AddChild(TextButton())
	self.VanillaText:SetFont(DEFAULTFONT)
	self.VanillaText:SetText("Vanilla")
	self.VanillaText:SetPosition(173, -27, 0)
	self.VanillaText:SetTextSize(24)
	self.VanillaText:SetColour(0,0,0,1)
	self.VanillaText:SetClickable(false)
	
	
	
	
	self.ModeText = self.optionsMenu:AddChild(TextButton())
	self.ModeText:SetFont(UIFONT)
	self.ModeText:SetText("Mode:")
	self.ModeText:SetPosition(30, 120, 0)
	self.ModeText:SetTextSize(33)
	self.ModeText:SetColour(0.25,0.25,0.25,1)
	self.ModeText:SetClickable(false)
	
	self.IncludeText = self.optionsMenu:AddChild(TextButton())
	self.IncludeText:SetFont(UIFONT)
	self.IncludeText:SetText("Include:")
	self.IncludeText:SetPosition(40, -49, 0)
	self.IncludeText:SetTextSize(33)
	self.IncludeText:SetColour(0.25,0.25,0.25,1)
	self.IncludeText:SetClickable(false)

	self.yearModeText = self.optionsMenu:AddChild(TextButton())
	self.yearModeText:SetFont(DEFAULTFONT)
	self.yearModeText:SetText("Yearly")
	self.yearModeText:SetPosition(63, 80, 0)
	self.yearModeText:SetTextSize(24)
	self.yearModeText:SetColour(0,0,0,1)
	self.yearModeText:SetClickable(false)
	
	self.seasonModeText = self.optionsMenu:AddChild(TextButton())
	self.seasonModeText:SetFont(DEFAULTFONT)
	self.seasonModeText:SetText("Seasonal")
	self.seasonModeText:SetPosition(173, 80, 0)
	self.seasonModeText:SetTextSize(24)
	self.seasonModeText:SetColour(0,0,0,1)
	self.seasonModeText:SetClickable(false)
	
	self.cycleModeText = self.optionsMenu:AddChild(TextButton())
	self.cycleModeText:SetFont(DEFAULTFONT)
	self.cycleModeText:SetText("Cycle")
	self.cycleModeText:SetPosition(280, 80, 0)
	self.cycleModeText:SetTextSize(24)
	self.cycleModeText:SetColour(0,0,0,1)
	self.cycleModeText:SetClickable(false)
	
	self.crockpotText = self.optionsMenu:AddChild(TextButton())
	self.crockpotText:SetFont(DEFAULTFONT)
	self.crockpotText:SetText("All crockpot foods")
	self.crockpotText:SetPosition(-179, 120, 0)
	self.crockpotText:SetTextSize(24)
	self.crockpotText:SetColour(0,0,0,1)
	self.crockpotText:SetClickable(false)
	
	self.crockpot10Text = self.optionsMenu:AddChild(TextButton())
	self.crockpot10Text:SetFont(DEFAULTFONT)
	self.crockpot10Text:SetText("10 random crockpot foods")
	self.crockpot10Text:SetPosition(-144, 80, 0)
	self.crockpot10Text:SetTextSize(24)
	self.crockpot10Text:SetColour(0,0,0,1)
	self.crockpot10Text:SetClickable(false)
	
	self.crockpot20Text = self.optionsMenu:AddChild(TextButton())
	self.crockpot20Text:SetFont(DEFAULTFONT)
	self.crockpot20Text:SetText("20 random crockpot foods")
	self.crockpot20Text:SetPosition(-142, 40, 0)
	self.crockpot20Text:SetTextSize(24)
	self.crockpot20Text:SetColour(0,0,0,1)
	self.crockpot20Text:SetClickable(false)
	
	self.rand10Text = self.optionsMenu:AddChild(TextButton())
	self.rand10Text:SetFont(DEFAULTFONT)
	self.rand10Text:SetText("10 random foods")
	self.rand10Text:SetPosition(-185, 0, 0)
	self.rand10Text:SetTextSize(24)
	self.rand10Text:SetColour(0,0,0,1)
	self.rand10Text:SetClickable(false)
	
	self.rand20Text = self.optionsMenu:AddChild(TextButton())
	self.rand20Text:SetFont(DEFAULTFONT)
	self.rand20Text:SetText("20 random foods")
	self.rand20Text:SetPosition(-185, -40, 0)
	self.rand20Text:SetTextSize(24)
	self.rand20Text:SetColour(0,0,0,1)
	self.rand20Text:SetClickable(false)
	
	self.rand30Text = self.optionsMenu:AddChild(TextButton())
	self.rand30Text:SetFont(DEFAULTFONT)
	self.rand30Text:SetText("30 random foods")
	self.rand30Text:SetPosition(-185, -80, 0)
	self.rand30Text:SetTextSize(24)
	self.rand30Text:SetColour(0,0,0,1)
	self.rand30Text:SetClickable(false)
	
	self.rand40Text = self.optionsMenu:AddChild(TextButton())
	self.rand40Text:SetFont(DEFAULTFONT)
	self.rand40Text:SetText("40 random foods")
	self.rand40Text:SetPosition(-185, -120, 0)
	self.rand40Text:SetTextSize(24)
	self.rand40Text:SetColour(0,0,0,1)
	self.rand40Text:SetClickable(false)
	
	self.easyText = self.optionsMenu:AddChild(TextButton())
	self.easyText:SetFont(DEFAULTFONT)
	self.easyText:SetText("hard-to-get")
	self.easyText:SetPosition(224, -90, 0)
	self.easyText:SetTextSize(24)
	self.easyText:SetColour(0,0,0,1)
	self.easyText:SetClickable(false)
	
	self.longtermText = self.optionsMenu:AddChild(TextButton())
	self.longtermText:SetFont(DEFAULTFONT)
	self.longtermText:SetText("longterm")
	self.longtermText:SetPosition(79, -90, 0)
	self.longtermText:SetTextSize(24)
	self.longtermText:SetColour(0,0,0,1)
	self.longtermText:SetClickable(false)
	
	self.rareText = self.optionsMenu:AddChild(TextButton())
	self.rareText:SetFont(DEFAULTFONT)
	self.rareText:SetText("rare")
	self.rareText:SetPosition(56, -130, 0)
	self.rareText:SetTextSize(24)
	self.rareText:SetColour(0,0,0,1)
	self.rareText:SetClickable(false)
	
	self.cavesText = self.optionsMenu:AddChild(TextButton())
	self.cavesText:SetFont(DEFAULTFONT)
	self.cavesText:SetText("caves")
	self.cavesText:SetPosition(197, -130, 0)
	self.cavesText:SetTextSize(24)
	self.cavesText:SetColour(0,0,0,1)
	self.cavesText:SetClickable(false)
end

function foodMenu:checkBoxUpdate()
	if self.options.SW %2 == 0 then
		self.SW:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {150,-130})
	else
		self.SW:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {150,-130})
	end
	if self.options.RoG %2 == 0 then
		self.RoG:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {150,-130})
	else
		self.RoG:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {150,-130})
	end
	if self.options.Vanilla %2 == 0 then
		self.Vanilla:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {150,-130})
	else
		self.Vanilla:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {150,-130})
	end

	if self.options.yearMode == true then
		self.yearMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {1,1}, { 15, 80 })
	else
		self.yearMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.1,.1}, {15,80})
	end
	if self.options.seasonMode == true then
		self.seasonMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { 115, 80 })
	else
		self.seasonMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {115,80})
	end
	if self.options.cycleMode == true then
		self.cycleMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { 235, 80 })
	else
		self.cycleMode:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {235,80})
	end

	if self.options.crockpot == true then
		self.crockpot:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, {-310, 120 })
	else
		self.crockpot:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-310,120})
	end
	if self.options.crockpot10 == true then
		self.crockpot10:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, {-310, 80 })
	else
		self.crockpot10:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-310,80})
	end
	if self.options.crockpot20 == true then
		self.crockpot20:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { -290, 40 })
	else
		self.crockpot20:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-290,40})
	end
	if self.options.rand10 == true then
		self.rand10:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { -290, 0 })
	else
		self.rand10:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-290,0})
	end
	if self.options.rand20 == true then
		self.rand20:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { -290, -40 })
	else
		self.rand20:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-290,-40})
	end
	if self.options.rand30 == true then
		self.rand30:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { -290, -80 })
	else
		self.rand30:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-290,-80})
	end
	if self.options.rand40 == true then
		self.rand40:SetTextures("images/pickyeater_ui.xml", "radiobutton_on.tex","radiobutton_on.tex", "radiobutton_on.tex", nil, nil, {.75,.75}, { -290, -120 })
	else
		self.rand40:SetTextures("images/pickyeater_ui.xml", "radiobutton_off.tex", "radiobutton_off.tex", "radiobutton_off.tex", nil, nil, {.75,.75}, {-290,-120})
	end

	if self.options.easy % 2 == 0 then
		self.easy:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {150,-90})
	else
		self.easy:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {150,-90})
	end
	if self.options.longterm % 2 == 0 then
		self.longterm:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {15,-90})
	else
		self.longterm:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {15,-90})
	end
	if self.options.rare % 2 == 0 then
		self.rare:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {15,-130})
	else
		self.rare:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {15,-130})
	end
	if self.options.caves % 2 == 0 then
		self.caves:SetTextures("images/pickyeater_ui.xml", "checkbox_on.tex", "checkbox_on_highlight.tex", "checkbox_on_disabled.tex", nil, nil, {1,1}, {150,-130})
	else
		self.caves:SetTextures("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {1,1}, {150,-130})
	end
end

function foodMenu:checkBoxes()
	self.SW = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.1,.1}, {-125,-263}))
	self.SW:SetPosition(118, 35)
	if PrefabExists("jellyjerky") and PrefabExists("palmleaf_hut") and SEASONS and SEASONS.DRY then
		self.SW:SetOnClick(function() 
			self.options.SW = self.options.SW + 1
			self:checkBoxUpdate()
		end) 
	else
		self.SW:SetTooltip("This is disabled because SW prefabs don't exist.")
	end	
	
	self.RoG = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-263}))
	self.RoG:SetPosition(118, 5)
	if IsDLCEnabled and REIGN_OF_GIANTS and IsDLCEnabled(REIGN_OF_GIANTS) then
		self.RoG:SetOnClick(function() 
			self.options.RoG = self.options.RoG + 1
			self:checkBoxUpdate()
		end) 
	elseif PrefabExists("acorn") and PrefabExists("catcoonden") and SEASONS and SEASONS.SPRING then
		self.RoG:SetOnClick(function() 
			self.options.RoG = self.options.RoG + 1
			self:checkBoxUpdate()
		end) 
	else
		self.RoG:SetTooltip("This is disabled because RoG prefabs don't exist.")
	end
	
	self.Vanilla = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-263}))
	self.Vanilla:SetPosition(118, -25)
  	self.Vanilla:SetOnClick(function() 
		self.options.Vanilla = self.options.Vanilla + 1
		self:checkBoxUpdate()
	end) 	



	self.yearMode = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.1,.1}, {-125,-203}))
	self.yearMode:SetPosition(15,80)
  	self.yearMode:SetOnClick(function() 
		if self.options.yearMode == false then
			self.options.yearMode = true
			self.options.seasonMode = false
			self.options.cycleMode = false
			self:checkBoxUpdate()
		end
	end) 
	self.seasonMode = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.seasonMode:SetPosition(110, 80)
  	self.seasonMode:SetOnClick(function() 
		if self.options.seasonMode == false then
			self.options.yearMode = false
			self.options.seasonMode = true
			self.options.cycleMode = false
			self:checkBoxUpdate()
		end
	end) 
	self.cycleMode = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.cycleMode:SetPosition(235, 80)
  	self.cycleMode:SetOnClick(function() 
		if self.options.cycleMode == false then
			self.options.yearMode = false
			self.options.seasonMode = false
			self.options.cycleMode = true
			self:checkBoxUpdate()
		end
	end) 	

	self.crockpot = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.crockpot:SetPosition(-290, 120)
  	self.crockpot:SetOnClick(function() 
		if self.options.crockpot == false then
			self.options.crockpot = true		
			self.options.crockpot10 = false	
			self.options.crockpot20 = false	
			self.options.rand10 = false	
			self.options.rand20 = false	
			self.options.rand30 = false
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 	
	self.crockpot10 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.crockpot10:SetPosition(-290, 80)
  	self.crockpot10:SetOnClick(function() 
		if self.options.crockpot10 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = true	
			self.options.crockpot20 = false	
			self.options.rand10 = false	
			self.options.rand20 = false	
			self.options.rand30 = false
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 	
	self.crockpot20 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.crockpot20:SetPosition(-290, 40)
  	self.crockpot20:SetOnClick(function() 
		if self.options.crockpot20 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = false	
			self.options.crockpot20 = true
			self.options.rand10 = false	
			self.options.rand20 = false	
			self.options.rand30 = false
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 
	self.rand10 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.rand10:SetPosition(-290, 0)
  	self.rand10:SetOnClick(function() 
		if self.options.rand10 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = false	
			self.options.crockpot20 = false	
			self.options.rand10 = true	
			self.options.rand20 = false	
			self.options.rand30 = false
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 
	self.rand20 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.rand20:SetPosition(-290, -40)
  	self.rand20:SetOnClick(function() 
		if self.options.rand20 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = false	
			self.options.crockpot20 = false	
			self.options.rand10 = false	
			self.options.rand20 = true	
			self.options.rand30 = false
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 	
	self.rand30 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.rand30:SetPosition(-290, -80)
  	self.rand30:SetOnClick(function() 
		if self.options.rand30 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = false	
			self.options.crockpot20 = false	
			self.options.rand10 = false	
			self.options.rand20 = false	
			self.options.rand30 = true
			self.options.rand40 = false
			self:checkBoxUpdate()
		end
	end) 
	self.rand40 = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.rand40:SetPosition(-290, -120)
  	self.rand40:SetOnClick(function() 
		if self.options.rand40 == false then
			self.options.crockpot = false		
			self.options.crockpot10 = false	
			self.options.crockpot20 = false	
			self.options.rand10 = false	
			self.options.rand20 = false	
			self.options.rand30 = false
			self.options.rand40 = true
			self:checkBoxUpdate()
		end
	end) 
	
	self.easy = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.easy:SetPosition(150,-90)
  	self.easy:SetOnClick(function() 
		self.options.easy = self.options.easy + 1		
		self:checkBoxUpdate()
	end) 
	self.longterm = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-125,-203}))
	self.longterm:SetPosition(15,-90)
  	self.longterm:SetOnClick(function() 
		self.options.longterm = self.options.longterm + 1		
		self:checkBoxUpdate()
	end) 
	
	
	self.rare = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-300,-203}))
	self.rare:SetPosition(15,-130)
  	self.rare:SetOnClick(function() 
		self.options.rare = self.options.rare + 1		
		self:checkBoxUpdate()
	end) 
	
	self.caves = self.optionsMenu:AddChild(ImageButton("images/pickyeater_ui.xml", "checkbox_off.tex", "checkbox_off_highlight.tex", "checkbox_off_disabled.tex", nil, nil, {.75,.75}, {-300,-203}))
	self.caves :SetPosition(150,-130)
  	self.caves:SetOnClick(function() 
		self.options.caves = self.options.caves + 1		
		self:checkBoxUpdate()
	end) 
	self:checkBoxUpdate()
end

return foodMenu
